/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.actions.AbstractDynamicBranchItem;
import com.aptana.git.ui.internal.actions.SquashMergeBranchHandler;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SquashMergeBranchItem
extends AbstractDynamicBranchItem {
    public SquashMergeBranchItem() {
    }

    public SquashMergeBranchItem(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        IResource resource = this.getSelectedResource();
        if (resource == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        GitRepository repo = this.getGitRepositoryManager().getAttached(resource.getProject());
        if (repo == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        ArrayList<SquashMergeBranchContributionItem> contributions = new ArrayList<SquashMergeBranchContributionItem>();
        for (String branchName : repo.allBranches()) {
            contributions.add(new SquashMergeBranchContributionItem(repo, branchName));
        }
        return contributions.toArray(new IContributionItem[contributions.size()]);
    }

    private static class SquashMergeBranchContributionItem
    extends ContributionItem {
        private GitRepository repo;
        private String branchName;

        SquashMergeBranchContributionItem(GitRepository repo, String branchName) {
            this.repo = repo;
            this.branchName = branchName;
        }

        public void fill(Menu menu, int index) {
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText(this.branchName);
            menuItem.setEnabled(!this.branchName.equals(this.repo.currentBranch()));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SquashMergeBranchHandler.mergeBranch(SquashMergeBranchContributionItem.this.repo, SquashMergeBranchContributionItem.this.branchName);
                }
            });
        }
    }
}

